<?php
/**
 * Plugin Name: Hub tv Custom Elements
 * Description: Custom elements for elementor
 * Version: 0.0.1
 * Author: Aaron
 * Text Domain: hubtv-custom-elements
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

// This file is pretty much a boilerplate WordPress plugin.
// It does very little except including wp-widget.php

class HubtvCustomElements {
    private static $instance = null;

    public static function get_instance() {
        if (!self::$instance) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    public function init() {
        add_action('elementor/elements/categories_registered', [$this, 'add_elementor_widget_categories']);
        add_action('elementor/widgets/widgets_registered', [$this, 'widgets_registered']);
        add_action('elementor/frontend/after_enqueue_styles', [$this, 'widget_styles']);
    }

    public function add_elementor_widget_categories($elements_manager) {
        $elements_manager->add_category(
            'hubtv-custom-elements',
            [
                'title' => __( 'Hub Custom Elements', 'plugin-name' ),
                'icon' => 'fa fa-plug',
            ]
        );
    }

    public function widgets_registered() {
        // Checks if the Elementor plugin is installed and activated
        if (defined('ELEMENTOR_PATH') && class_exists('Elementor\Widget_Base')) {
            require_once plugin_dir_path(__FILE__).'widgets/work-services-widget/work-services-widget.php';
            require_once plugin_dir_path(__FILE__).'widgets/work-videos-widget/work-videos-widget.php';
            require_once plugin_dir_path(__FILE__).'widgets/repeatable-speaker-widget/repeatable-speaker-widget.php';
            require_once plugin_dir_path(__FILE__).'widgets/the-session-list-widget/the-session-list-widget.php';
            require_once plugin_dir_path(__FILE__).'widgets/whats-new-carousel-widget/whats-new-carousel-widget.php';
            require_once plugin_dir_path(__FILE__).'widgets/home-awards-widget/home-awards-widget.php';
            require_once plugin_dir_path(__FILE__).'widgets/home-clients-widget/home-clients-widget.php';
            require_once plugin_dir_path(__FILE__).'widgets/blog-info-widget/blog-info-widget.php';
            require_once plugin_dir_path(__FILE__).'widgets/blog-prev-next-widget/blog-prev-next-widget.php';
            require_once plugin_dir_path(__FILE__).'widgets/wistia-popup-widget/wistia-popup-widget.php';
            require_once plugin_dir_path(__FILE__).'widgets/case-study-widget/case-study-widget.php';
            require_once plugin_dir_path(__FILE__).'widgets/team-grid-widget/team-grid-widget.php';
            require_once plugin_dir_path(__FILE__).'widgets/work-child-list-widget/work-child-list-widget.php';
            require_once plugin_dir_path(__FILE__).'widgets/child-page-list-widget/child-page-list-widget.php';
            require_once plugin_dir_path(__FILE__).'widgets/fixed-prev-next-widget/fixed-prev-next-widget.php';
            require_once plugin_dir_path(__FILE__).'widgets/contact-page-logos-widget/contact-page-logos-widget.php';
            require_once plugin_dir_path(__FILE__).'widgets/insight-breakfast-list-widget/insight-breakfast-list-widget.php';
        }
    }

    public function widget_styles() {
        wp_register_style('work-services-widget', plugins_url('widgets/work-services-widget/work-services-widget.css', __FILE__));
        wp_register_style('work-videos-widget', plugins_url('widgets/work-videos-widget/work-videos-widget.css', __FILE__));
        wp_register_style('repeatable-speaker-widget', plugins_url('widgets/repeatable-speaker-widget/repeatable-speaker-widget.css', __FILE__));
        wp_register_style('the-session-list-widget', plugins_url('widgets/the-session-list-widget/the-session-list-widget.css', __FILE__));
        wp_register_style('whats-new-carousel-widget', plugins_url('widgets/whats-new-carousel-widget/whats-new-carousel-widget.css', __FILE__));
        wp_register_style('home-awards-widget', plugins_url('widgets/home-awards-widget/home-awards-widget.css', __FILE__));
        wp_register_style('home-clients-widget', plugins_url('widgets/home-clients-widget/home-clients-widget.css', __FILE__));
        wp_register_style('blog-info-widget', plugins_url('widgets/blog-info-widget/blog-info-widget.css', __FILE__));
        wp_register_style('blog-prev-next-widget', plugins_url('widgets/blog-prev-next-widget/blog-prev-next-widget.css', __FILE__));
        wp_register_style('case-study-widget', plugins_url('widgets/case-study-widget/case-study-widget.css', __FILE__));
        wp_register_style('team-grid-widget', plugins_url('widgets/team-grid-widget/team-grid-widget.css', __FILE__));
        wp_register_style('work-child-list-widget', plugins_url('widgets/work-child-list-widget/work-child-list-widget.css', __FILE__));
        wp_register_style('child-page-list-widget', plugins_url('widgets/child-page-list-widget/child-page-list-widget.css', __FILE__));
        wp_register_style('fixed-prev-next-widget', plugins_url('widgets/fixed-prev-next-widget/fixed-prev-next-widget.css', __FILE__));
        wp_register_style('contact-page-logos-widget', plugins_url('widgets/contact-page-logos-widget/contact-page-logos-widget.css', __FILE__));
        wp_register_style('insight-breakfast-list-widget', plugins_url('widgets/insight-breakfast-list-widget/insight-breakfast-list-widget.css', __FILE__));

        wp_enqueue_style('work-services-widget');
        wp_enqueue_style('work-videos-widget');
        wp_enqueue_style('repeatable-speaker-widget');
        wp_enqueue_style('the-session-list-widget');
        wp_enqueue_style('whats-new-carousel-widget');
        wp_enqueue_style('home-awards-widget');
        wp_enqueue_style('home-clients-widget');
        wp_enqueue_style('blog-info-widget');
        wp_enqueue_style('blog-prev-next-widget');
        wp_enqueue_style('case-study-widget');
        wp_enqueue_style('team-grid-widget');
        wp_enqueue_style('work-child-list-widget');
        wp_enqueue_style('child-page-list-widget');
        wp_enqueue_style('fixed-prev-next-widget');
        wp_enqueue_style('contact-page-logos-widget');
        wp_enqueue_style('insight-breakfast-list-widget');

    }
}

HubtvCustomElements::get_instance()->init();
