<?php
namespace Elementor;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Custom_Blog_Info_Widget extends Widget_Base {
    public function get_name() {
        return 'blog-info';
    }

    public function get_title() {
        return __('Blog Info Widget', 'blog-info');
    }

    public function get_icon() {
        return 'fa fa-star';
    }

    public function get_categories() {
        return ['hubtv-custom-elements'];
    }

    protected function render() {
        global $post;

        $cta = get_field('cta', $value);

        echo '<div class="blog-info-container">';
        echo    '<div class="info-box">';
        echo        '<div class="blog-author-image">'.get_wp_user_avatar(get_the_author_meta('ID'), 32).'</div>';
        echo        '<div class="author-info">';
        echo            '<span class="author-name">by '.get_the_author().'</span>';
        echo            '<span class="publish-date">'.date_format(date_create($post->post_date),"d/m/Y").'</span>';
        echo            '<div class="share-links">';
        // Linked In
        echo                '<a target="_blank" rel="noopener noreferrer" href="https://www.linkedin.com/shareArticle?mini=true&amp;url='.get_permalink($post->ID).'&amp;title='.$post->post_title.'&amp;summary='.$post->post_title.'" aria-label="Share on LinkedIn">';
        echo                    '<i class="fa fa-linkedin"></i>';
        echo                '</a>';
        // Facebook
        echo                '<a target="_blank" rel="noopener noreferrer" href="https://facebook.com/sharer/sharer.php?u='.get_permalink($post->ID).'" aria-label="Share on Facebook">';
        echo                    '<i class="fa fa-facebook"></i>';
        echo                '</a>';
        // Twitter
        echo                '<a target="_blank" rel="noopener noreferrer" href="https://www.twitter.com/intent/tweet/?text=Hub%20-%20'.rawurlencode($post->post_title).'&amp;url='.get_permalink($post->ID).'" aria-label="Share on Twitter">';
        echo                    '<i class="fa fa-twitter"></i>';
        echo                '</a>';
        echo            '</div>';
        echo        '</div>';
        echo    '</div>';
        if (!empty($cta) && $cta['link']) {
            echo '<div class="blog-info-cta">';
            echo    '<a href="'.$cta["link"]["url"].'" target="_blank" rel="noopener noreferrer" style="background-color: '.$cta["background_colour"].'; color:'.$cta["text_colour"].'">'.$cta["link"]["title"].'</a>';
            echo '</div>';
        }
        echo '</div>';
    }

    protected function _content_template() {}
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Custom_Blog_Info_Widget());