<?php
namespace Elementor;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Custom_Blog_Prev_Next_Widget extends Widget_Base {
    const MAX_TITLE_CHARS = 25;
    const ELLIPSIS_SYMBOL = "...";
    const ELLIPSIS_TITLE_LENGTH = 22;

    public function get_name() {
        return 'blog-prev-next';
    }

    public function get_title() {
        return __('Blog Prev Next Widget', 'blog-prev-next');
    }

    public function get_icon() {
        return 'fa fa-plus';
    }

    public function get_categories() {
        return ['hubtv-custom-elements'];
    }

    private function limit_title_length($title) {
        if(strlen($title) <= Custom_Blog_Prev_Next_Widget::MAX_TITLE_CHARS) {
            return $title;
        } else {
            $last_char = $title{Custom_Blog_Prev_Next_Widget::ELLIPSIS_TITLE_LENGTH + 1};
            $limited_title = substr($title, 0, Custom_Blog_Prev_Next_Widget::MAX_TITLE_CHARS - 3) . Custom_Blog_Prev_Next_Widget::ELLIPSIS_SYMBOL;

            // If the limited title doesn't ends exactly at the end of a word, end it at the end of the previous word
            if(!preg_match('/\s|[.:,;]\s/', $last_char)) {
                preg_match('/(^.*)\s+.*$/', $limited_title, $match);

                if(sizeof($match) > 1) {
                    $limited_title = $match[1] . Custom_Blog_Prev_Next_Widget::ELLIPSIS_SYMBOL;
                }
            } 

            return $limited_title;
        }
    }

    protected function render() {
        $prev_post = get_adjacent_post(false, '', true);
        $next_post = get_adjacent_post(false, '', false);

        echo '<div class="blog-prev-next-container">';
        echo    '<div class="previous-blog large">';
        if (!empty($prev_post)) {
            echo ('
                <a href="'.get_permalink($prev_post->ID).'" class="previous-button">
                    <span>Previous</span>
                    <div class="previous-arrow">&#9664;&#xFE0E;</div>
                </a>
                <div class="blog-title">'. Custom_Blog_Prev_Next_Widget::limit_title_length($prev_post->post_title) .'</div>
            ');
        }
        echo    '</div>';
        echo    '<div class="next-blog large">';
        if (!empty($next_post)) {
            echo ('
                <a href="'.get_permalink($next_post->ID).'" class="next-button">
                    <span>Next</span>
                    <div class="next-arrow">&#9654;&#xFE0E;</div>
                </a>
                <div class="blog-title">'. Custom_Blog_Prev_Next_Widget::limit_title_length($next_post->post_title) .'</div>
            ');
        }
        echo    '</div>';


        if (!empty($prev_post)) {
            echo ('
                <div class="previous-page-container small">
                    <a class="fixed-page-link" href="'.get_permalink($prev_post->ID).'">
                        <span class="triangle">&#9664;&#xFE0E;</span>
                        <div class="rotated-text-container">
                            <span>'.Custom_Blog_Prev_Next_Widget::limit_title_length($prev_post->post_title).'</span>
                        </div>
                        <span class="triangle">&#9664;&#xFE0E;</span>
                    </a>
                </div>
            ');
        }
        if (!empty($next_post)) {
            echo ('
                <div class="next-page-container small">
                    <a class="fixed-page-link" href="'.get_permalink($next_post->ID).'">
                        <span class="triangle">&#9654;&#xFE0E;</span>
                        <div class="rotated-text-container">
                            <span>'.Custom_Blog_Prev_Next_Widget::limit_title_length($next_post->post_title).'</span>
                        </div>
                        <span class="triangle">&#9654;&#xFE0E;</span>
                    </a>
                </div>
            ');
        }
        echo '</div>';
    }

    protected function _content_template() {}
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Custom_Blog_Prev_Next_Widget());
