<?php
namespace Elementor;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Custom_Case_Study_Widget extends Widget_Base {
    public function get_name() {
        return 'case-study-widget';
    }

    public function get_title() {
        return __('Case Study Widget', 'case-study-widget');
    }

    public function get_icon() {
        return 'fa fa-plus';
    }

    public function get_categories() {
        return ['hubtv-custom-elements'];
    }

    protected function render() {
        $case_study = get_field('case_study');
        $class = "";

        preg_match('/\/([^\/]+)\/$/', $case_study, $matches);

        if (count($matches) === 2) {
            $class .= " " . $matches[1];
        }

        if ($case_study) {
            echo '<div class="case-study-widget ' . $class . '">';
            echo    '<a class="case-study-link ' . $class . '" target="_blank" rel="noopener noreferrer" href="' . $case_study . '">';
            echo        '<span class="case-study-download ' . $class . '">Download Case Study</span>';
            echo    '</a>';
            echo    '<span class="case-study-view">View Case Study</span>';
            echo '</div>';
        }
    }
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Custom_Case_Study_Widget());
