<?php
namespace Elementor;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}


class Child_Page_List_Widget extends Widget_Base {
    public function get_name() {
        return 'child-page-list';
    }

    public function get_title() {
        return __('Child Page List Widget', 'child-page-list');
    }

    public function get_icon() {
        return 'fa fa-list-alt';
    }

    public function get_categories() {
        return ['hubtv-custom-elements'];
    }

    protected function render() {
        global $post;

        $child_pages = get_pages([
            'child_of' => $post->ID,
            'sort_column' => 'menu_order',
            'sort_order' => 'desc'
        ]);

        echo '<div class="custom-elementor-widget child-page-list-container">';

        foreach($child_pages as $index => $value) {
            echo '<a class="child-link" href="'.get_permalink($value->ID).'" style="background-image: url('.get_field('page_thumb_image', $value->ID)['sizes']['medium_large'].')">';
            echo    '<div>';
            echo        '<span>'.get_field('page_title', $value->ID).'</span>';
            echo    '</div>';
            echo '</a>';
        }

        echo '</div>';
    }

    protected function _content_template() {}
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Child_Page_List_Widget());
