<?php
namespace Elementor;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Custom_Contact_Page_Logos_Widget extends Widget_Base {
    public function get_name() {
        return 'contact-page-logos-widget';

    }

    public function get_title() {
        return __('Contact Page Logos Widget', 'contact-page-logos-widget');
    }

    public function get_icon() {
        return 'fa fa-plus';
    }

    public function get_categories() {
        return ['hubtv-custom-elements'];
    }

    protected function render() {
        $external_links = get_field('page_links');

        echo '<div class="contact-page-logos-container">';
        foreach($external_links as $key => $external_link) {
            echo '<a target="_blank" rel="noopener noreferrer" href="'.$external_link['link_address'].'" style="background-image:url('.$external_link['logo_image']['sizes']['medium'].');"><img src="'.$external_link['logo_image']['sizes']['medium'].'" alt="'.$external_link['logo_image']['alt'].'"></a>';
        }
        echo '</div>';
    }
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Custom_Contact_Page_Logos_Widget());
