<?php
namespace Elementor;

if (!defined( 'ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Fixed_Previous_Next_Buttons_Widget extends Widget_Base {
    public function get_name() {
        return 'fixed-prev-next';
    }

    public function get_title() {
        return __('Previous & Next Button Widget', 'fixed-prev-next');
    }

    public function get_icon() {
        return 'fa fa-arrows-h';
    }

    public function get_categories() {
        return ['hubtv-custom-elements'];
    }

    protected function render() {
        global $post;

        $previous_page;
        $next_page;

        $parents_children = get_pages(['child_of' => $post->post_parent, 'sort_column' => 'menu_order']);

        foreach($parents_children as $key => $value) {
            if ($value->menu_order == $post->menu_order + 1) {

                $previous_page = $value;
            } else if ($value->menu_order == $post->menu_order - 1) {

                $next_page = $value;
            }
        }

        echo '<div class="custom-elementor-widget">';
            if (!empty($previous_page)) {
                echo ('
                    <div class="previous-page-container">
                        <a class="fixed-page-link" href="'.get_permalink($previous_page->ID).'">
                            <span class="triangle">&#9664;&#xFE0E;</span>
                            <div class="rotated-text-container">
                                <span>'.get_field('page_title', $previous_page->ID).'</span>
                            </div>
                            <span class="triangle">&#9664;&#xFE0E;</span>
                        </a>
                    </div>
                ');
            }
            if (!empty($next_page)) {
                echo ('
                    <div class="next-page-container">
                        <a class="fixed-page-link" href="'.get_permalink($next_page->ID).'">
                            <span class="triangle">&#9654;&#xFE0E;</span>
                            <div class="rotated-text-container">
                                <span>'.get_field('page_title', $next_page->ID).'</span>
                            </div>
                            <span class="triangle">&#9654;&#xFE0E;</span>
                        </a>
                    </div>
                ');
            }
        echo '</div>';

    }

    protected function _content_template() {}
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Fixed_Previous_Next_Buttons_Widget());