<?php
namespace Elementor;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}


class Custom_Home_Awards_Widget extends Widget_Base {
    public function get_name() {
        return 'home-awards-widget';
    }

    public function get_title() {
        return __('Home awards widget', 'home-awards-widget');
    }

    public function get_icon() {
        return 'fa fa-star';
    }

    public function get_categories() {
        return ['hubtv-custom-elements'];
    }

    protected function render() {
        $awards = get_field('awards');
        $shortlisted_awards = get_field('shortlisted');

        echo '<div class="award-container">';
        if (!empty($awards)) {
            echo '<div class="awarded">';
            echo    '<h4>Awards</h4>';
            echo    '<div class="awards-box">';
            foreach($awards as $index => $award) {
                echo    '<div class="award">';
                if (preg_match('~MSIE|Internet Explorer~i', $_SERVER['HTTP_USER_AGENT']) || (strpos($_SERVER['HTTP_USER_AGENT'], 'Trident/7.0; rv:11.0') !== false)) {
                    echo        '<div class="image-wrapper" style="background-image: url('.$award['award_image']['url'].')"><img src="'.$award['award_image']['url'].'" alt="'.$award['award_image']['alt'].'" style="opacity: 0"></div>';
                } else {
                    echo        '<div class="image-wrapper"><img src="'.$award['award_image']['url'].'" alt="'.$award['award_image']['alt'].'"></div>';
                }
                echo    '</div>';
            }
            if (count($awards) % 4 === 3) {
                echo '<div class="spacer-div"></div>';
            } else if (count($awards) % 4 === 2) {
                echo '<div class="spacer-div"></div>';
                echo '<div class="spacer-div"></div>';
            }
            echo    '</div>';
            echo '</div>';
        }
        if (!empty($shortlisted_awards)) {
            echo '<div class="shortlisted">';
            echo    '<h4>Shortlisted</h4>';
            echo    '<div class="shortlisted-awards-box">';
            foreach($shortlisted_awards as $index => $shortlisted_award) {
                echo    '<div class="award">';
                if (preg_match('~MSIE|Internet Explorer~i', $_SERVER['HTTP_USER_AGENT']) || (strpos($_SERVER['HTTP_USER_AGENT'], 'Trident/7.0; rv:11.0') !== false)) {
                    echo        '<div class="image-wrapper" style="background-image: url('.$shortlisted_award['shortlisted_image']['url'].')"><img src="'.$shortlisted_award['shortlisted_image']['url'].'" alt="'.$shortlisted_award['shortlisted_image']['alt'].'" style="opacity: 0"></div>';
                } else {
                    echo        '<div class="image-wrapper"><img src="'.$shortlisted_award['shortlisted_image']['url'].'" alt="'.$shortlisted_award['shortlisted_image']['alt'].'"></div>';
                }
                echo    '</div>';
            }
            echo    '</div>';
            echo '</div>';
        }
        echo '</div>';
    }
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Custom_Home_Awards_Widget());
