<?php
namespace Elementor;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Custom_Home_Clients_Widget extends Widget_Base {
    public function get_name() {
        return 'home-clients-widget';
    }

    public function get_title() {
        return __('Home clients widget', 'home-clients-widget');
    }

    public function get_icon() {
        return 'fa fa-star';
    }

    public function get_categories() {
        return ['hubtv-custom-elements'];
    }

    protected function render() {
        $clients = get_field('clients');

        echo '<div class="clients-container">';
        if (!empty($clients)) {
            foreach($clients as $index => $client) {
                echo '<div class="client">';

                if (preg_match('~MSIE|Internet Explorer~i', $_SERVER['HTTP_USER_AGENT']) || (strpos($_SERVER['HTTP_USER_AGENT'], 'Trident/7.0; rv:11.0') !== false)) {
                    echo        '<div class="image-wrapper" style="background-image: url('.$client['client_image']['url'].');background-position:center;background-repeat:no-repeat;background-size:contain;height:100%;width:100%"><img src="'.$client['client_image']['url'].'" alt="'.$client['client_image']['alt'].'" style="max-height:180px;width:100%;opacity:0"></div>';
                } else {
                    echo        '<div class="image-wrapper"><img src="'.$client['client_image']['url'].'" alt="'.$client['client_image']['alt'].'"></div>';
                }

                echo '</div>';
            }
        }
        echo '</div>';
    }
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Custom_Home_Clients_Widget());
