<?php
namespace Elementor;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Custom_Insight_Breakfast_List_Widget extends Widget_Base {
    public function get_name() {
        return 'insight-breakfast-list';
    }

    public function get_title() {
        return __('Insight Breakfast List Widget', 'insight-breakfast-list');
    }

    public function get_icon() {
        return 'fa fa-list';
    }

    public function get_categories() {
        return ['hubtv-custom-elements'];
    }

    protected function render() {
        $videos = get_field('insight_breakfast_videos');

        echo '<div class="insight-breakfast-videos-container" id="insight-breakfast-videos-container">';

        foreach($videos as $index => $video) {
            $wistiaEmbed =
            '<script src="https://fast.wistia.com/embed/medias/'.$video['video_code'].'.jsonp" async></script>
            <script src="https://fast.wistia.com/assets/external/E-v1.js" async></script>
            <span class="wistia_embed wistia_async_'.$video['video_code'].' popover=true popoverContent="link" videoFoam=true">
                <div class="image-wrapper" style="background-image:url('.$video['video_thumbnail_image']['sizes']['medium_large'].');background-position:50% 50%;background-size:cover;cursor:pointer;height:0;padding-bottom:56.25%;width:100%;">
                    <span class="play-btn" style="position:absolute;left:calc(50% - 65px);top:calc(50% - 50px);z-index:100;font-size:55px;background-color:#4b4b4b;border-radius:20px;padding:25px 45px;line-height:55px;color:white;opacity:0.8">&#9654;&#xFE0E;</span>
                </div>
            </span>';
            echo '<script>console.log('.json_encode($video).')</script>';
            echo '<div class="video-box">';
            echo    '<div class="video-container">'.$wistiaEmbed.'</div>';
            echo    '<div class="video-description">'.$video['video_title'].'</div>';
            echo '</div>';
        }

        echo '</div>';
    }

    protected function _content_template() {}
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Custom_Insight_Breakfast_List_Widget());
