<?php
namespace Elementor;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Custom_Repeatable_Speaker_Widget extends Widget_Base {
    public function get_name() {
        return 'repeatable-speaker';
    }

    public function get_title() {
        return __('Repeatable Speaker Widget', 'repeatable-speaker-widget');
    }

    public function get_icon() {
        return 'fa fa-star';
    }

    public function get_categories() {
        return ['hubtv-custom-elements'];
    }

    protected function render() {
        $event_speakers = get_field('event_speakers');

        echo '<div class="speakers-container">';
        foreach ($event_speakers as $index => $speaker) {
            echo '<div class="speaker-box">';
            echo    '<div class="speaker-image">';
            if (preg_match('~MSIE|Internet Explorer~i', $_SERVER['HTTP_USER_AGENT']) || (strpos($_SERVER['HTTP_USER_AGENT'], 'Trident/7.0; rv:11.0') !== false)) {
                echo        '<div class="image-wrapper" style="background-image: url('.$speaker['speaker_image']['url'].');background-position:50% 20%;background-size:cover"><img src="'.$speaker['speaker_image']['url'].'" alt="'.$speaker['speaker_image']['alt'].'" style="height:200px;opacity:0"></div>';
            } else {
                echo        '<div class="image-wrapper" style="height:100%;width:100%;"><img src="'.$speaker['speaker_image']['url'].'" alt="'.$speaker['speaker_image']['alt'].'" style="height:100%;width:100%;object-fit:cover"></div>';
            }
            echo    '</div>';
            echo    '<div class="speaker-text">';
            echo        '<span class="speaker-name">'.$speaker['speaker_name'].'</span>';
            echo        '<span class="speaker-description">'.$speaker['speaker_description'].'</span>';
            echo    '</div>';
            echo '</div>';
        }
        if (count($event_speakers)%3 === 2) {
            echo '<div class="speaker-box"></div>';
        }

        echo '</div>';
    }

    protected function _content_template() {}
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Custom_Repeatable_Speaker_Widget());
