<?php
namespace Elementor;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Team_Grid_Widget extends Widget_Base {
    public function get_name() {
        return 'team-grid';
    }

    public function get_title() {
        return __('Team Grid Widget', 'team-grid');
    }

    public function get_icon() {
        return 'fa fa-users';
    }

    public function get_categories() {
        return ['hubtv-custom-elements'];
    }

    protected function render() {
        $rows = get_field('add_person');

        echo '<div class="custom-elementor-widget">';
            echo '<div class="team-grid-container">';
            foreach($rows as $index => $row) {
                echo ('
                    <div class="team-member large" style="background-image: url('.$row['person_image']['sizes']['medium_large'].');">
                        <div class="team-member-content">
                            <span class="team-member-name">'.$row['person_name'].'</span>
                            <span class="team-member-title">'.$row['person_title'].'</span>
                        </div>
                    </div>
                    <div class="team-member small">
                        <div class="team-member-image" style="background-image: url('.$row['person_image']['sizes']['medium_large'].');"></div>
                        <div class="team-member-content">
                            <span class="team-member-name">'.$row['person_name'].'</span>
                            <span class="team-member-title">'.$row['person_title'].'</span>
                        </div>
                    </div>
                ');
            }
            echo '</div>';
        echo '</div>';
    }

    protected function _content_template() {}
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Team_Grid_Widget());
