<?php
namespace Elementor;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Custom_The_Session_List_Widget extends Widget_Base {
    public function get_name() {
        return 'the-session-list';
    }

    public function get_title() {
        return __('The Session List Widget', 'the-session-list');
    }

    public function get_icon() {
        return 'fa fa-star';
    }

    public function get_categories() {
        return ['hubtv-custom-elements'];
    }

    protected function render() {
        $videos = get_field('the_session_videos');

        $all_video_category_ids = [];

        foreach($videos as $index => $video) {
            if (!empty($video['video_categories'])) {
                $all_video_category_ids = array_unique(array_merge($all_video_category_ids, $video['video_categories']));
            }
        }

        $categories = get_categories();

        echo '<div class="video-filter-container">';
        echo    '<div class="video-filter">';
        echo        '<div class="video-filter-search">';
        echo            '<label>';
        echo                '<input id="video-text-search-input" type="text" placeholder="Text Search ...">';
        echo            '</label>';
        echo        '</div>';
        echo        '<div class="video-filter-category">';
        echo            '<label>';
        echo                '<select name="" id="video-category-filter-select">';
        echo                    '<option value="0">All Categories</option>';
        foreach($all_video_category_ids as $index => $category_id) {
            echo                '<option value="'.$category_id.'">'.get_the_category_by_ID($category_id).'</option>';
        }
        echo                '</select>';
        echo            '</label>';
        echo        '</div>';
        echo        '<div class="video-filter-date">';
        echo            '<label for="">';
        echo                '<select name="" id="video-date-filter-select">';
        echo                    '<option value="anytime">Anytime</option>';
        echo                    '<option value="today">Today</option>';
        echo                    '<option value="last-week">Last Week</option>';
        echo                    '<option value="last-month">Last Month</option>';
        echo                    '<option value="last-year">Last Year</option>';
        echo                '</select>';
        echo            '</label>';
        echo        '</div>';
        echo        '<div class="video-filter-reset">';
        echo            '<a id="video-filter-reset-link">Show All</a>';
        echo        '</div>';
        echo    '</div>';
        echo '</div>';

        echo '<div class="videos-container" id="videos-container">';
        foreach($videos as $index => $video) {
            $video_category_ids = $video['video_categories'] ? json_encode($video['video_categories']) : '[]';
            $video_date = $video['upload_date'];

            echo '<div class="video in-search in-cat in-date" data-video-title="'.$video['video_title'].'" data-video-categories="'.$video_category_ids.'" data-video-date='.$video_date.'>';
                echo '<div class="video-container">';
                echo    '<script src="https://fast.wistia.com/embed/medias/'.$video['video_code'].'.jsonp" async></script><script src="https://fast.wistia.com/assets/external/E-v1.js" async></script><div class="wistia_responsive_padding" style="padding:56.25% 0 0 0;position:relative;"><div class="wistia_responsive_wrapper" style="height:100%;left:0;position:absolute;top:0;width:100%;"><span class="wistia_embed wistia_async_'.$video['video_code'].' popover=true popoverAnimateThumbnail=true videoFoam=true" style="display:inline-block;height:100%;position:relative;width:100%">&nbsp;</span></div></div>';
                echo '</div>';
                echo '<div class="subscribe-btn-container">';
                echo    '<a target="_blank" rel="noopener noreferrer" href="https://www.youtube.com/channel/UCB8zSguz8fkA-9exLOf8Yfw?sub_confirmation=1">Subscribe</a>';
                echo '</div>';
                echo '<span class="video-date">'.$video['upload_date'].'</span>';
                echo '<span class="video-description">'.$video['video_description'].'</span>';
            echo '</div>';
        }
        echo '</div>';
    }

    protected function _content_template() {}
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Custom_The_Session_List_Widget());
