<?php
namespace Elementor;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Custom_Whats_New_Carousel_Widget extends Widget_Base {
    public function get_name() {
        return 'whats-new-carousel';
    }

    public function get_title() {
        return __('What\'s new carousel widget', 'whats-new-carousel-widget');
    }

    public function get_icon() {
        return 'fa fa-star';
    }

    public function get_categories() {
        return ['hubtv-custom-elements'];
    }

    protected function render() {
        $slides = get_field('carousel_slides');

        echo '<div class="whats-new-container">';
        echo '<h2>What\'s New</h2>';
        echo    '<div class="whats-new-carousel large">';
        if ($slides) {
            foreach($slides as $index => $slide) {
                echo '<a href="'.$slide['slide_link'].'">';
                if ($index === 0) {
                    echo '<div class="pane pane1 active" id="pane1">';
                } else {
                    echo '<div class="pane pane'.($index+1).'" id="pane'.($index+1).'">';
                }
                if (preg_match('~MSIE|Internet Explorer~i', $_SERVER['HTTP_USER_AGENT']) || (strpos($_SERVER['HTTP_USER_AGENT'], 'Trident/7.0; rv:11.0') !== false)) {
                    echo    '<div class="image-wrapper" style="background-image: url('.$slide['slide_image']['sizes']['large'].')"><img class="transparent" src="'.$slide['slide_image']['url'].'" alt="'.$slide['slide_image']['alt'].'"></div>';
                } else {
                    echo    '<div class="image-wrapper"><img src="'.$slide['slide_image']['sizes']['large'].'" alt="'.$slide['slide_image']['alt'].'"></div>';
                }
                echo        '<h4>'.$slide['slide_title'].'</h4>';
                echo        '<p>'.$slide['slide_description'].'</p>';
                echo    '</div>';
                echo '</a>';
            }
        }
        echo    '</div>';

        echo    '<div class="carousel-nav-btns">';
        if ($slides) {
            foreach($slides as $index => $slide) {
                if ($index === 0) {
                    echo '<span class="carousel-nav-btn carousel-btn-1 active" id="carousel-btn-1"></span>';
                } else {
                    echo '<span class="carousel-nav-btn carousel-btn-'.($index+1).'" id="carousel-btn-'.($index+1).'"></span>';
                }
            }
        }
        echo    '</div>';
        echo '</div>';
    }
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Custom_Whats_New_Carousel_Widget());
