<?php
namespace Elementor;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Custom_Wistia_Popup_Widget extends Widget_Base {
    public function get_name() {
        return 'wistia-popup-widget';
    }

    public function get_title() {
        return __('Wistia Popup Widget', 'wistia-popup-widget');
    }

    public function get_icon() {
        return 'fa fa-video-camera';
    }

    public function get_categories() {
        return ['hubtv-custom-elements'];
    }

    protected function render() {
        echo '<div class="background-popupvid-container">';
        if (get_field('page_video_code')) {
            echo('
                <script src="https://fast.wistia.com/embed/medias/'.get_field('page_video_code').'.jsonp" async></script>
                <script src="https://fast.wistia.com/assets/external/E-v1.js" async></script>
                <span class="wistia_embed wistia_async_'.get_field('page_video_code').' popover=true popoverContent=link" style="display:inline;position:relative">
                    <a href="#" style="display: block; position: relative">
                        <span class="play-btn" style="position:absolute;left:calc(50% - 65px);top:calc(50% - 50px);z-index:100;font-size:55px;background-color:#4b4b4b;border-radius:20px;padding:25px 45px;line-height:55px;color:white;opacity:0.8">&#9654;&#xFE0E;</span>
            ');
        }

        if (preg_match('~MSIE|Internet Explorer~i', $_SERVER['HTTP_USER_AGENT']) || (strpos($_SERVER['HTTP_USER_AGENT'], 'Trident/7.0; rv:11.0') !== false)) {
            echo        '<div class="image-wrapper" style="background-image: url('.get_field('page_thumb_image')['url'].');background-position:50% 10%;background-size:cover"><img src="'.get_field('page_thumb_image')['url'].'" alt="'.get_field('page_thumb_image')['alt'].'" style="max-height:500px;width:100vw;opacity:0"></div>';
        } else {
            echo        '<div class="image-wrapper"><img src="'.get_field('page_thumb_image')['url'].'" alt="'.get_field('page_thumb_image')['alt'].'" style="max-height:500px;width:100vw;object-fit:cover;object-position:50% 10%"></div>';
        }
        if (get_field('page_video_code')) {
            echo ('
                    </a>
                </span>
            ');
        }
        echo '</div>';
    }

    protected function _content_template() {}
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Custom_Wistia_Popup_Widget());
