<?php
namespace Elementor;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Custom_Work_Child_List_Widget extends Widget_Base {
    public function get_name() {
        return 'work-child-list-widget';
    }

    public function get_title() {
        return __('Work Page Child List Widget', 'work-child-list-widget');
    }

    public function get_icon() {
        return 'fa fa-list';
    }

    public function get_categories() {
        return ['hubtv-custom-elements'];
    }

    public function render() {
        global $post;

        $child_pages = get_pages([
            'child_of' => $post->ID,
            'sort_column' => 'menu_order',
            'sort_order' => 'desc'
        ]);

        echo '<div class="custom-elementor-widget">';
        foreach($child_pages as $index => $value) {
            if ($index <= 3) {
                echo '<a href="'.get_permalink($value->ID).'" class="work-child-section">';
            } else {
                echo '<a href="'.get_permalink($value->ID).'" class="work-child-section hidden-section">';
            }

            if ($index % 2 == 0) {
                echo    '<div class="image-column" style="background-image: url('.get_field('page_thumb_image', $value->ID)['sizes']['large'].');"></div>';
            }
            echo ('
                        <div class="text-column">
                            <h3 style="font-size:30px;color:white;">'.get_field('page_title', $value->ID).'</h3>
                            <p>'.get_field('page_excerpt', $value->ID).'</p>
                            <div class="small-image">
                                <img src="'.get_field('page_thumb_image', $value->ID)['sizes']['large'].'">
                            </div>
                            <span class="view-project-text">Click to view project  <span class="triangles">&#9654;&#xFE0E;&#9654;&#xFE0E;</span></span>
                        </div>
            ');
            if ($index % 2 != 0) {
                echo    '<div class="image-column" style="background-image: url('.get_field('page_thumb_image', $value->ID)['sizes']['large'].');"></div>';
            }
            echo    '</a>';
        }
        echo        '<div class="show-all-btn-container">';
        echo            '<button id="work-show-all-btn">Show All</button>';
        echo        '</div>';
        echo '</div>';
    }

    public function _content_template() {}
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Custom_Work_Child_List_Widget());
