<?php
namespace Elementor;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Custom_Work_Services_Widget extends Widget_Base {
    public function get_name() {
        return 'work-services';
    }

    public function get_title() {
        return __('Work Services Widget', 'work-services-widget');
    }

    public function get_icon() {
        return 'fa fa-star';
    }

    public function get_categories() {
        return ['hubtv-custom-elements'];
    }

    protected function render() {
        $services = get_field('relevant_services');
        if (!empty($services)) {
            echo '<div class="work-services-container">';
            foreach($services as $index => $service) {
                echo '<a class="service-link" href="'.$service['service_link'].'">';
                echo    '<div class="circle" style="background-color:'.$service['circle_colour'].'"></div>';
                echo    '<div class="text"><span>'.$service['service_name'].'</span></div>';
                echo '</a>';
            }
            echo '</div>';
        }
    }

    protected function _content_template() {}
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Custom_Work_Services_Widget());
