<?php
namespace Elementor;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Custom_Work_Videos_Widget extends Widget_Base {
    public function get_name() {
        return 'work-videos';
    }

    public function get_title() {
        return __('Work Videos Widget', 'work-videos');
    }

    public function get_icon() {
        return 'fa fa-star';
    }

    public function get_categories() {
        return ['hubtv-custom-elements'];
    }

    public function render() {
        $videos = get_field('videos');

        if (!empty($videos)) {
            echo '<script src="https://fast.wistia.com/assets/external/E-v1.js" async></script>';
            echo '<h2 class="videos-section-title">Related videos</h2>';
            echo '<div class="work-videos-container">';

            foreach($videos as $index => $video) {
                echo '<div class="work-video-container">';
                echo    '<script src="https://fast.wistia.com/embed/medias/'.$video['video_id'].'.jsonp" async></script>';
                echo    '<div class="wistia_responsive_padding" style="padding:56.25% 0 0 0;position:relative;">';
                echo        '<div class="wistia_responsive_wrapper" style="height:100%;left:0;position:absolute;top:0;width:100%;">';
                echo            '<span class="wistia_embed wistia_async_'.$video['video_id'].' popover=true popoverAnimateThumbnail=true videoFoam=true" style="display:inline-block;height:100%;position:relative;width:100%">&nbsp;</span>';
                echo        '</div>';
                echo    '</div>';
                echo    '<div class="video-title">'.$video['video_title'].'</div>';
                echo '</div>';
            }

            echo '</div>';
        }
    }
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Custom_Work_Videos_Widget());
