<?php
add_action('wp_enqueue_scripts', 'enqueue_child_theme_styles', PHP_INT_MAX);

add_action('wp_enqueue_scripts', 'enqueue_child_theme_scripts', PHP_INT_MAX);

function enqueue_child_theme_styles() {
    wp_enqueue_style('parent-style', get_template_directory_uri().'/style.css');
    wp_enqueue_style('custom-header-style', get_stylesheet_directory_uri().'/css/header.css', array(), wp_get_theme()->get('Version'));
    wp_enqueue_style('custom-search-filter-results-style', get_stylesheet_directory_uri().'/css/search-filter-results.css', array(), wp_get_theme()->get('Version'));
    wp_enqueue_style('custom-cookie-notice-style', get_stylesheet_directory_uri().'/css/cookie-notice.css', array(), wp_get_theme()->get('Version'));
}

function enqueue_child_theme_scripts() {
    wp_enqueue_script('custom-header-script', get_stylesheet_directory_uri().'/js/header.js', array(), wp_get_theme()->get('Version'));
}

function WPTime_redirect_404_to_homepage(){
    if( is_404() ){
        wp_redirect( home_url(), 301 );
        exit();
    }
}
add_action('template_redirect', 'WPTime_redirect_404_to_homepage');

/**
 * Enable ACF 5 early access
 * Requires at least version ACF 4.4.12 to work
 */
define('ACF_EARLY_ACCESS', '5');
