<?php
/**
 * The header for Astra Theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Astra
 * @since 1.0.0
 */

?><!DOCTYPE html>
<?php astra_html_before(); ?>
<html <?php language_attributes(); ?>>
<head>

<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-KJRK9C6');</script>
<!-- End Google Tag Manager -->

<!-- Start Favicon -->
<link rel="apple-touch-icon" sizes="180x180" href="<?php echo get_stylesheet_directory_uri(); ?>/apple-touch-icon.png">
<link rel="icon" type="image/png" sizes="32x32" href="<?php echo get_stylesheet_directory_uri(); ?>/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="<?php echo get_stylesheet_directory_uri(); ?>/favicon-16x16.png">
<link rel="manifest" href="<?php echo get_stylesheet_directory_uri(); ?>/site.webmanifest">
<link rel="mask-icon" href="<?php echo get_stylesheet_directory_uri(); ?>/safari-pinned-tab.svg" color="#5bbad5">
<meta name="msapplication-TileColor" content="#da532c">
<meta name="theme-color" content="#ffffff">
<!-- End Favicon -->

<?php astra_head_top(); ?>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">

<?php astra_head_bottom(); ?>
<?php wp_head(); ?>
</head>

<body <?php astra_schema_body(); ?> <?php body_class(); ?>>
    
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-KJRK9C6"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->

<!-- Cookie consent banner -->
<?php if ($_SERVER['REQUEST_URI'] !== '/privacy/') { ?>
<div id="cookie-modal" class="suppressed">
    <div id="cookie-box">
        <h2 id="cookie-box-title">Use of Cookies</h2>
        <div id="cookie-box-divider"></div>
        <p>We use cookies to improve your experience on our site and analyse how our site is being used.</p>
        <p>For more information on how cookies are used please review our <a href="/privacy">cookie policy</a> or decline our analytical and performance cookies by clicking <a id="cookie-consent-decline-btn">here</a>.</p>
        <button id="cookie-consent-accept-btn">Accept & Continue</button>
    </div>
</div>
<?php } ?>
<!-- End Cookie consent banner -->

<?php $siteUrl = site_url() ?>
<?php if ($_SERVER['REQUEST_URI'] !== '/privacy/') { ?>
<nav class="nav-element">
    <div class="nav-content">
        <div class="nav-logo">
            <a href="<?php echo $siteUrl ?>/">
                <img src="<?php echo get_stylesheet_directory_uri().'/images/hub_logo_black.png' ?>" alt="Hub logo">
            </a>
        </div>

        <div class="nav-links-container larger">
            <ul>
                <li class="nav-link <?php if (is_page('work')) echo 'active-link'; ?>">
                    <a href="<?php echo $siteUrl ?>/work/">Work</a>
                </li>
                <li class="nav-link <?php if (is_page('services')) echo 'active-link'; ?>">
                    <a href="<?php echo $siteUrl ?>/services/">Services</a>
                </li>
                <li class="nav-link <?php if (is_page('about')) echo 'active-link'; ?>">
                    <a href="<?php echo $siteUrl ?>/about/">About</a>
                </li>
                <li class="nav-link <?php if (is_page('people')) echo 'active-link'; ?>">
                    <a href="<?php echo $siteUrl ?>/people/">People</a>
                </li>
                <li class="nav-link nav-parent-link">
                    <a>Our Blogs</a>
                    <ul class="nav-link-child-links">
                        <li class="nav-child-link <?php if (is_page('blog')) echo 'active-child-link'; ?>">
                            <a href="<?php echo $siteUrl ?>/blog/">Blog</a>
                        </li>
                        <li class="nav-child-link <?php if (is_page('digital-trailblazers')) echo 'active-child-link'; ?>">
                            <a href="<?php echo $siteUrl ?>/digital-trailblazers/">Digital Trailblazers</a>
                        </li>
                    </ul>
                </li>
                <li class="nav-link <?php if (is_page('insight-breakfast')) echo 'active-link'; ?>">
                    <a href="<?php echo $siteUrl ?>/insight-breakfast/">Our Events</a>
                </li>
                <li class="nav-link <?php if (is_page('contact')) echo 'active-link'; ?>">
                    <a href="<?php echo $siteUrl ?>/contact/">Contact</a>
                </li>
            </ul>
        </div>


        <div class="smaller">
            <div id="burger-menu">
                <span id="burger-top"></span>
                <span id="burger-middle"></span>
                <span id="burger-bottom"></span>
            </div>

            <div class="navigation-container" id="navigation-page">
                <ul>
                    <li class="navigation-link">
                        <a href="<?php echo $siteUrl ?>/">Home</a>
                    </li>
                    <li class="navigation-link">
                        <a href="<?php echo $siteUrl ?>/work/">Work</a>
                    </li>
                    <li class="navigation-link">
                        <a href="<?php echo $siteUrl ?>/services/">Services</a>
                    </li>
                    <li class="navigation-link">
                        <a href="<?php echo $siteUrl ?>/about/">About</a>
                    </li>
                    <li class="navigation-link">
                        <a href="<?php echo $siteUrl ?>/people/">People</a>
                    </li>
                    <li class="navigation-link navigation-parent-link">
                        <a>Our Blogs</a>
                        <ul>
                            <li>
                                <a href="<?php echo $siteUrl ?>/blog/">- Blog</a>
                            </li>
                            <li>
                                <a href="<?php echo $siteUrl ?>/digital-trailblazers/">- Digital Trailblazers</a>
                            </li>
                        </ul>
                    </li>
                    <li class="navigation-link">
                        <a href="<?php echo $siteUrl ?>/insight-breakfast/">Our Events</a>
                    </li>
                    <li class="navigation-link">
                        <a href="<?php echo $siteUrl ?>/contact/">Contact</a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</nav>
<?php } ?>
