document.addEventListener("DOMContentLoaded", function(event) {
    document.getElementById('burger-menu').addEventListener('click', function() {
        this.classList.toggle('active');
        document.getElementById('navigation-page').classList.toggle('open');
    });



    var cookieModal = document.getElementById('cookie-modal')
    if (cookieModal && document.cookie.indexOf('cookie-consent-status=accepted') === -1) {
        cookieModal.classList.remove('suppressed')
    }

    var cookieConsentAcceptButton = document.getElementById('cookie-consent-accept-btn');
    if (cookieConsentAcceptButton) {
        cookieConsentAcceptButton.addEventListener('click', function() {
            window.dataLayer = window.dataLayer || [];
            window.dataLayer.push({
                'event': 'cookieConsentAccepted'
            })
    
            var expiryDate = new Date()
            expiryDate.setFullYear(expiryDate.getFullYear() + 1)
    
            document.cookie = `cookie-consent-status=accepted;expires=${expiryDate};path=/;`;

            cookieModal.classList.add('suppressed');
        });
    }

    var cookieConsentDeclineButton = document.getElementById('cookie-consent-decline-btn')
    if (cookieConsentDeclineButton) {
        cookieConsentDeclineButton.addEventListener('click', function() {
            var expiryDate = new Date()
            expiryDate.setFullYear(expiryDate.getFullYear() + 1)

            document.cookie = `cookie-consent-status=declined;expires=${expiryDate};path=/;`;

            cookieModal.classList.add('suppressed');
        });
    }
});