<?php
// PSLtoolkit main page
?>

<?php get_header(); ?>
<section id="content" role="main" class='container'>
  <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
    <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
      <header class="header">
        <h1 class="entry-title island-bottom">Workshops</h1>
      </header>
      <section class="entry-content">
        <?php the_content(); ?>


        <?php $add_forms = get_field('add_forms');?>
        <?php if($add_forms):?>
          <div class='contact-forms'>
            <?php echo $add_forms;?>
          </div>
        <?php endif; ?>
        <div class="entry-links"><?php wp_link_pages(); ?></div>
      </section>
    </article>
    <?php if ( ! post_password_required() ) comments_template( '', true ); ?>
  <?php endwhile; endif; ?>



  <!--taxonmomy terms-->
  <?php $terms = get_terms( array(
    'taxonomy' => 'psl_catergories',
    'hide_empty' => false,
  ) );
  ?>
  <div class='row tax-web island-bottom'>
    <?php foreach($terms as $term):?>
      <?php $link = get_term_link($term->term_taxonomy_id);?>
      <div class='col-12 col-4-m island-bottom-margin'>
        <a href='<?php echo $link;?>'>
          <div class='inner' data-match-height="tax-height">

            <h2 class='island-half' data-match-height="main-title-height"><?php echo $term->name;?></h2>
            <p data-match-height="main-text-height">
              <?php echo $term->description;?>
            </p>

          </div>
        </a>
      </div>
    <?php endforeach; ?>
  </div>


    <h2 class='island'>Latest Videos</h2>

  <div class='row gls-web island-bottom'>

    <?php
    $args = array(
      'post_type' => 'psl_toolkit',
      'orderby' => 'date',
      'order' => 'ASC',
      'posts_per_page' => '6'
    );
    $custom_query = new WP_Query($args); // exclude category 9
    while($custom_query->have_posts()) : $custom_query->the_post(); ?>

    <?php //Var
    $excert = get_field('excert');
    $care_resources = get_field('care_resources');
    $replacement_feature_image = get_field('replacement_feature_image');
    ?>
    <div class='col-12 col-4-m island-bottom-margin'>
      <a href='<?php the_permalink(); ?>'>
        <div class='inner' data-match-height="web-height">

          <?php if($replacement_feature_image):?>
            <div class='img island-half-bottom'>
              <img class='full-width' src="<?php echo $replacement_feature_image['url'];?>" />
            </div>
          <?php endif; ?>

          <h2 class='island-half' data-match-height="title-height"><?php echo $post->post_title; ?></h2>
          <?php if($excert):?>
            <div class='description' data-match-height="desc-height">
              <?php echo ShortenText($excert); ?>
            </div>
          <?php endif; ?>

        </div>
      </a>
    </div>

  <?php endwhile; ?>
</div>
<?php wp_reset_postdata(); // reset the query ?>
</section>


<?php get_footer(); ?>
